unit Unit1;

interface

{==============================================================================}
{ This demo shows how to use Tags of items.                                    }
{ Each item has associated integer value - Tag. Tags are used to store         }
{ additional information, which RichView does not display and does not use.    }
{------------------------------------------------------------------------------}
{ All Add*** methods (except from the obsolete ones) have Add***Tag versions.  }
{ Add***(...) == Add***Tag(...,0) (Tags=0 by default)                          }
{ For example, look AddNLTag and AddHotpotExTag in this demo.                  }
{ Tag of item can be obtained with GetItemTag method (or Get***Info methods)   }
{ and modified with SetItemTag (or Set***Info methods).                        }
{==============================================================================}

{I RV_Defs.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  {$IFDEF RICHVIEWDEF4}
  ImgList,
  {$ENDIF}
  RVStyle, ExtCtrls, RVScroll, RichView, CRVFData, SclRView;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    RVStyle1: TRVStyle;
    ImageList1: TImageList;
    Image1: TImage;
    srv: TSRichViewEdit;
    procedure FormCreate(Sender: TObject);
    procedure RichView1Jump(Sender: TObject; id: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var ico: TIcon;
begin
  srv.SetMargin(5, 5, 5, 5);

  srv.RichViewEdit.AddNL('Some text styles can be chosen as hypertext styles. ',0,0);
  srv.RichViewEdit.AddNLTag('Like this one.',4,-1, 100);
  srv.RichViewEdit.AddNL(' You can have as many hypertext styles as you want.  ',0,-1);
  srv.RichViewEdit.AddNLTag('Here is one more.',5,-1,  200);
  srv.RichViewEdit.AddNL('Images from Image Lists also can be hypertext: ',0,0);
  srv.RichViewEdit.AddHotspotExTag('Pen Image', 0,1, ImageList1, -1, 300);
  srv.RichViewEdit.AddNL(' Such images are called "hotspots".',0,-1);
  ico := TIcon.Create;
  ico.Assign(Image1.Picture.Graphic);
  srv.RichViewEdit.AddHotPictureTag('Bobo', ico, -1, rvvaBaseLine, 400);
  srv.RichViewEdit.Format;
end;

procedure TForm1.RichView1Jump(Sender: TObject; id: Integer);
var ItemNo: Integer;
    RVData: TCustomRVFormattedData;
    Tag: Integer;
begin
  srv.RichViewEdit.GetJumpPointLocation(id, RVData, ItemNo);
  Tag := RVData.GetItemTag(ItemNo);
  Panel1.Caption := 'Clicked: Item with Tag='+IntToStr(Tag);
end;

end.
